global root "C:\Users\Ian\Dropbox (MIT)\CE EIP replication"
global mongey "$root/Work from home/MPW_SocialDistancing_JEI2021_Replication"

// March CPS Data 
use "$mongey/Data/CPS/clean_cps19.dta", clear

//________________________________________
// LWFH* and HPP*
merge m:1 occ using "$mongey/Data/onet_occ_clean.dta", keep(mat) nogen

* 1 minus proportion of activities that must be done in person
gen wfh_prop = (17-low_wfh)/17

* re-classify education levels to match CE
gen educ_ce_cps = .
replace educ_ce_cps = 1 if inlist(educ,2,10,20,30) // Up to gr 8
replace educ_ce_cps = 2 if inlist(educ,40,50,60,71) // Gr 9 to 12 (no diploma)
replace educ_ce_cps = 3 if educ==73 // High school
replace educ_ce_cps = 4 if educ==81 // Some college, no degree
replace educ_ce_cps = 5 if inlist(educ,91,92) // Associate's
replace educ_ce_cps = 6 if educ==111 // Bachelor's
replace educ_ce_cps = 7 if inlist(educ,123,124,125) // Advanced
assert !mi(educ_ce_cps) if !mi(educ)

* re-classify industry-occupation to match CE
gen ind_ce_cps = .
replace ind_ce_cps = 1 if inrange(occ,10,430) // Manager, prof. administrator
replace ind_ce_cps = 2 if inrange(occ,2200,2550) // Teacher
replace ind_ce_cps = 3 if inrange(occ,500,1860) | inrange(occ,2100,2160) // Professional
replace ind_ce_cps = 4 if inrange(occ,5000,5920) // Administrative support, including clerical
replace ind_ce_cps = 5 if inrange(occ,4700,4760) | inrange(occ,4830,4840) | inrange(occ,4940,4950) // Sales, retail
replace ind_ce_cps = 6 if inrange(occ,4800,4820) | inrange(occ,4850,4930) // Sales, business goods, and services
replace ind_ce_cps = 7 if inrange(occ,1900,1965) // Technician service
replace ind_ce_cps = 8 if inrange(occ,3700,3955) // Protective service
replace ind_ce_cps = 9 if inrange(occ,4600,4640) // Private household service
replace ind_ce_cps = 10 if inrange(occ,2000,2050) | inrange(occ,3000,3655) | inrange(occ,4000,4240) | inrange(occ,4300,4320) | inrange(occ,4400,4540) // Other service
replace ind_ce_cps = 11 if inrange(occ,7700,9740) // Machine or transportation operator, laborer
replace ind_ce_cps = 12 if inrange(occ,6200,7630) // Construction workers, mechanics
replace ind_ce_cps = 13 if inrange(occ,4340,4350) | inrange(occ,6005,6050) // Farming
replace ind_ce_cps = 14 if inlist(occ,4250) | inlist(occ,6120,6130) // Forestry, fishing, groundskeeping
replace ind_ce_cps = 15 if inrange(occ,-1,-2) // Armed forces (does not exist)
replace ind_ce_cps = 0 if inrange(occ,2600,2920) // Ian unable to classify
assert !mi(ind_ce_cps) if !mi(occ)

gen one = 1

* collapse into averages
gcollapse (mean) wfh_prop (rawsum) count=one [aw=asecwt] if weeks_ann>=10, by(ind_ce_cps educ_ce_cps)
drop if ind_ce_cps==0

*Assume military had no layoffs (100% retention)
qui count
local newobs = r(N) + 7
set obs `newobs'
replace ind_ce_cps = 15 if mi(ind_ce_cps)
bys ind_ce_cps (educ_ce_cps): replace educ_ce_cps = _n if mi(educ_ce_cps)
replace wfh_prop = 1 if ind_ce_cps==15
replace count = 0 if ind_ce_cps==15

xtset ind_ce_cps educ_ce_cps
tsfill, full

* take closest approximation if missing
replace wfh_prop = wfh_prop[45] if ind_ce_cps==7 & inlist(educ_ce_cps,1,2)
replace count = 0 if mi(count)

compress
save "$root/CE EIP I/Raw Data/wfh_occ_educ.dta", replace
save "$root/CE EIP II/Raw Data/wfh_occ_educ.dta", replace
save "$root/CE EIP III/Raw Data/wfh_occ_educ.dta", replace